import statistics
import wandb


def print_final_results(
    settings,
    test_acc_runs_best_ece,
    test_em_ece_runs_best_ece,
    test_auc_runs_best_ece,
    test_acc_runs_best_acc,
    test_em_ece_runs_best_acc,
    test_auc_runs_best_acc,
    test_acc_runs_best_auc,
    test_em_ece_runs_best_auc,
    test_auc_runs_best_auc,
):
    print("%%%%%%%%%%%%%%%%%%% FINAL RESULTS %%%%%%%%%%%%%%%%%%%")
    if settings.train_mode == 1:
        print("------- VALIDATION -------")
        print(
            "---> Val best accuracy mean {:.3f} and std {:.3f}.".format(
                statistics.mean(settings.best_val_acc_runs),
                statistics.stdev(settings.best_val_acc_runs),
            )
        )
        print(
            "---> Val best EM-ECE mean {:.3f} and std {:.3f}.".format(
                statistics.mean(settings.best_val_ece_runs),
                statistics.stdev(settings.best_val_ece_runs),
            )
        )
        print(
            "---> Val best AUC mean {:.3f} and std {:.3f}.".format(
                statistics.mean(settings.best_val_auc_runs),
                statistics.stdev(settings.best_val_auc_runs),
            )
        )
        print()
        print()
    print("------- TEST -------")
    print(
        "---> Final accuracy mean {:.3f} and std {:.3f} for best EM-ECE model.".format(
            statistics.mean(test_acc_runs_best_ece),
            statistics.stdev(test_acc_runs_best_ece),
        )
    )
    print(
        "---> Final EM-ECE mean {:.3f} and std {:.3f} for best EM-ECE model.".format(
            statistics.mean(test_em_ece_runs_best_ece),
            statistics.stdev(test_em_ece_runs_best_ece),
        )
    )
    print(
        "---> Final AUC mean {:.3f} and std {:.3f} for best EM-ECE model.".format(
            statistics.mean(test_auc_runs_best_ece),
            statistics.stdev(test_auc_runs_best_ece),
        )
    )
    print()
    print(
        "---> Final accuracy mean {:.3f} and std {:.3f} for best accuracy model.".format(
            statistics.mean(test_acc_runs_best_acc),
            statistics.stdev(test_acc_runs_best_acc),
        )
    )
    print(
        "---> Final EM-ECE mean {:.3f} and std {:.3f} for best accuracy model.".format(
            statistics.mean(test_em_ece_runs_best_acc),
            statistics.stdev(test_em_ece_runs_best_acc),
        )
    )
    print(
        "---> Final AUC mean {:.3f} and std {:.3f} for best accuracy model.".format(
            statistics.mean(test_auc_runs_best_acc),
            statistics.stdev(test_auc_runs_best_acc),
        )
    )
    print()
    print(
        "---> Final accuracy mean {:.3f} and std {:.3f} for best AUC model.".format(
            statistics.mean(test_acc_runs_best_auc),
            statistics.stdev(test_acc_runs_best_auc),
        )
    )
    print(
        "---> Final EM-ECE mean {:.3f} and std {:.3f} for best AUC model.".format(
            statistics.mean(test_em_ece_runs_best_auc),
            statistics.stdev(test_em_ece_runs_best_auc),
        )
    )
    print(
        "---> Final AUC mean {:.3f} and std {:.3f} for best AUC model.".format(
            statistics.mean(test_auc_runs_best_auc),
            statistics.stdev(test_auc_runs_best_auc),
        )
    )
